;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-

;;; Reason: Added new function convert-server-6.0-to-6.1.This utility will create a REL 6.1 Visidoc Server file using the Rel 6.0 file. Two attributes in the NAMESPACE class,VISIDOC-SERVER object need to be updated to reflect the new version. The manual files have not changed, thus requiring no updates to the manual directory or the remaining class object in the server file.
;;; NOTE: Run this utility before executing INITIALIZE-VISIDOC-SERVER.

;;;                           RESTRICTED RIGHTS LEGEND
;;;
;;; Use, duplication, or disclosure by the Government is subject to
;;; restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;; Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;   TEXAS INSTRUMENTS INCORPORATED      
;;;   P.O. BOX 2909, M/S 2151             
;;;   AUSTIN, TEXAS 78769                 
;;;
;;; Copyright (C) 1989 Texas Instruments Incorporated.
;;; All rights reserved.

;;; Written 06/06/90 12:58:26 by BERGER,
;;; while running on ARIES from band LODA
;;; With SYSTEM 6.36, VIRTUAL-MEMORY 6.3, EH 6.8, MAKE-SYSTEM 6.3, MICRONET 6.0, LOCAL-FILE 6.2,
;;;  BASIC-PATHNAME 6.5, NETWORK-SUPPORT-COLD 6.2, BASIC-NAMESPACE 6.8, NETWORK-NAMESPACE 6.1,
;;;  DISK-IO 6.3, DISK-LABEL 6.0, BASIC-FILE 6.13, MAC-PATHNAME 6.0, NETWORK-PATHNAME 6.2,
;;;  COMPILER 6.18, TV 6.26, DATALINK 6.0, CHAOSNET 6.8, GC 6.4, MEMORY-AUX 6.0, NVRAM 6.3,
;;;  SYSLOG 6.2, STREAMER-TAPE 6.6, UCL 6.0, INPUT-EDITOR 6.0, METER 6.2, ZWEI 6.21,
;;;  DEBUG-TOOLS 6.4, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3, DATALINK-DISPLAYS 6.0,
;;;  FONT-EDITOR 6.1, SERIAL 6.0, PRINTER 6.7, MAC-PRINTER-TYPES 6.2, PRINTER-TYPES 6.2,
;;;  IMAGEN 6.1, SUGGESTIONS 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.8, TELNET 6.1, VT100 6.0,
;;;  NAMESPACE-EDITOR 6.5, PROFILE 6.3, VISIDOC 6.7, TI-CLOS 6.49, CLEH 6.5, IP 3.65,
;;;  Experimental CLX 6.11, CLUE 6.104, X11M 6.26, Experimental BUG 11.19, VISIDOC-SERVER 6.1,
;;;   microcode 483, Band Name: 6.1-A 5-31 +P6/4

#!C
; From file NAMESPACE-SERVER.LISP#> VISIDOC.SERVER; Hotel:
#10R DOX#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOX"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: VISIDOC.SERVER; NAMESPACE-SERVER.#"


(defun convert-server-6.0-to-6.1 ()
  "This utility will create a REL 6.1 Visidoc Server file using the Rel 6.0 file. Two attributes in the
    NAMESPACE class, VISIDOC-SERVER object need to be updated to reflect the new version. The manual files
    have not changed, thus requiring no updates to the manual directory or the remaining class object in
    the server file."
  (let (namespace)
    (COND ((probe-file "lm:name-service;visidoc-server-rel-6-1.xld")
	   (format t "~%The visidoc server file LM:NAME-SERVICE;VISIDOC-SERVER-REL-6-1.XLD has already been converted."))
	  ((not (probe-file "lm:name-service;visidoc-server-rel-6-0.xld"))
	   (format t "~%LM:NAME-SERVICE;VISIDOC-SERVER-REL-6-0.XLD does not exist. Conversion failed."))
	  (T					;now do the real work.
	   (format t "~%Beginning conversion.~%Copying 6.0 XLD to 6.1 XLD.")
	   (fs:copy-file "lm:name-service;visidoc-server-rel-6-0.xld"
			 "lm:name-service;visidoc-server-rel-6-1.xld")
	   (format t "~%Loading unmodified 6.1 XLD.")
	   (setf namespace (name:load-personal-namespace "visidoc-server-rel-6-1" 
							 :pathname "lm:name-service;visidoc-server-rel-6-1.xld"))
	   (format t "~%Updating attributes.")
	   (name:add-attribute "visidoc-server" :NAMESPACE :NAMESPACE-FILE-PATHNAME
			       "lm:name-service;visidoc-server-rel-6-1.xld"
			       :namespace namespace)
	   (name:add-attribute "visidoc-server" :NAMESPACE :VERSION
			       :REL-6-1
			       :namespace namespace)
	   (Format t "~%Saving changes to XLD file.")
	   (SEND namespace :DUMP "lm:name-service;visidoc-server-rel-6-1.xld#>")
	   (format t "~%Cleaning up.")
	   (name:delete-namespace "visidoc-server-rel-6-1")
	   (format t "~%The visidoc server file LM:NAME-SERVICE;VISIDOC-SERVER-REL-6-1.XLD has been created."))))
  )
))
